﻿/*
VERSION: 1.2
1.2			Added "request_min_elevation" and "request_max_elevation" event responders
1.1			Send "change_elevation" events to the player

USAGE:
	#include "functions/riseLower.as"
	player_mc.rise_obj = makeRiseLower( player_mc );										// this handles changes in "elevation"
	#include "functions/tank_move.as"
	player_mc.move_obj = makeTankMove( player_mc, player_mc.sprite );		// this moves the player
	
	player_mc.rise_obj.resetVelocity();		// set velocity to Zero		(useful when switching between movement systems in real-time)
	player_mc.move_obj.resetVelocity();		// set velocity to Zero		(useful when switching between movement systems in real-time)
	
	onUnload = function(){
		clearInterval(rise_obj.loopInterval);
		clearInterval(move_obj.loopInterval);
	}
	
	
SETTINGS:
	maxSpeed				Maximum ascend/descend speed
	acel						Ascend/descend acelleration,  how many pixels to rise/lower per frame while a key is pressed
	decel						Ascend/descend deceleration,  multiplier that reduces velocity per frame when no key is pressed
	
	key_higher	Key code for rotating left
	key_lower		Key code for rotating right
	
	
PROPERTIES:
	maxSpeed				Maximum rotation speed  (in elevations)
	acel						Acelleration speed,  how many pixels the velocity increases per frame while a key is pressed
	decel						Deceleration speed, multiplier that reduces velocity per frame when no key is pressed
	elevation				Current rotation,  used to represent the facing direction
	min_elevation		Lowest allowed elevation value
	max_elevation		Highest allowed elevation value
	
	
RAM.keys defaults
	RAM.keys.higher
	RAM.keys.lower
	
	
EVENTS:
	unload
	change					Same as change_radian
	request_elevation
	request_min_elevation
	request_max_elevation
	
PLAYER EVENTS:
	change_elevation			{value: newElevation}
	
RESPONDS TO PLAYER EVENTS:
	unload
	request_elevation
	change_elevation
	request_min_elevation
	request_max_elevation
	
*/
function makeRiseLower( player_mc ){
	#include "getImpliedValue.as"
	#include "eventSystem3.as"
	var _this = {};		// external interface
	AsBroadcaster.initialize( _this );
	var react = make_react( _this );		// param is optional
	react.to( "unload" ).from( player_mc ).tell( _this );
	react.to( "change" ).tell( player_mc, "change_elevation");
	react.to( "change_elevation" ).from( player_mc ).tell( _this );
	
	
	// Variables
	var fps = 30;
	// movement speed
	_this._acel = getImpliedValue(acel) || 1;										// acelleration increment
	_this._decel = getImpliedValue(decel) || 0.6;								// brake multiplier
	_this._elevation = getImpliedValue(elevation) || 0;					// current elevation
	_this._maxSpeed = getImpliedValue(maxSpeed) || 5;						
	_this._min_elevation = getImpliedValue(min_elevation) || 0;
	_this._max_elevation = getImpliedValue(max_elevation) || 0;
	_this.vel = 0;
	// controls
	_this.key_higher = RAM.keys.higher || 0;		// 0 = disabled
	_this.key_lower = RAM.keys.lower || 0;			// 0 = disabled
	// allow the "elevation" rotation to be accessed externally
	_this.addProperty( "elevation", function(){
		return _this._elevation;
	}, function( newValue ){
		// limit the elevation values to the min and max range
		if( newValue < _this._min_elevation )		newValue = _this._min_elevation;
		if( newValue > _this._max_elevation )		newValue = _this._max_elevation;
		// no change => abort
		if( newValue === _this._elevation )		return;
		// apply new value
		_this._elevation = getImpliedValue( newValue );
		// announce new value
		sendEvent( "change", {value: _this._elevation}, _this);
		// sendEvent( "change_elevation", {value: _this._elevation}, player_mc);
	});
	
	
	
	_this.addProperty( "acel", function(){
		return _this._acel;
	}, function( newValue ){
		_this._acel = getImpliedValue( newValue );
	});
	_this.addProperty( "decel", function(){
		return _this._decel;
	}, function( newValue ){
		_this._decel = getImpliedValue( newValue );
	});
	_this.addProperty( "maxSpeed", function(){
		return _this._maxSpeed;
	}, function( newValue ){
		_this._maxSpeed = getImpliedValue( newValue );
		if( _this.vel > _this._maxSpeed )		_this.vel = _this._maxSpeed;
	});
	
	_this.addProperty( "min_elevation", function(){
		return _this._min_elevation;
	}, function( newValue ){
		_this._min_elevation = getImpliedValue( newValue );
		if( _this._min_elevation > elevation )		elevation = _this._min_elevation;
	});
	_this.addProperty( "max_elevation", function(){
		return _this._max_elevation;
	}, function( newValue ){
		_this._max_elevation = getImpliedValue( newValue );
		if( _this._max_elevation < elevation )		elevation = _this._max_elevation;
	});
	
	
	// Data request events
	react.to( "request_elevation").then = function( evt ){
		evt.callback( _this._elevation );
	}
	react.to( "request_elevation").from( player_mc ).tell( _this );
	
	
	react.to( "request_min_elevation").then = function( evt ){
		evt.callback( _this._min_elevation );
	}
	react.to( "request_min_elevation").from( player_mc ).tell( _this );
	
	
	react.to( "request_max_elevation").then = function( evt ){
		evt.callback( _this._max_elevation );
	}
	react.to( "request_max_elevation").from( player_mc ).tell( _this );
	
	
	
	// 
	_this.resetVelocity = function(){
		_this.vel = 0;
	}// resetVelocity()
	
	
	
	// update elevation when outside sources change it
	react.to( "change_elevation" ).then = function( evt ){
		_this.elevation = Number( evt.value ) || 0;
	}// change_elevation()
	
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// Main Program
	_this.loop = function(){
		//  Abort if the player sprite doesn't exist
		if(player_mc._currentframe === undefined){
			sendEvent("unload");
			return;
		}// if:   player_mc is missing
		
		_this.vel = changeVelocity( _this.vel );
		// update total speeds
		var oldElevation = _this.elevation;
		_this.elevation += _this.vel;		// elevation
		if( _this.elevation === oldElevation )		_this.vel = 0;
		
	}// loop()
	_this.loopInterval = setInterval( function(){
		_this.loop();
	}, 1000/fps );
	react.to( "unload").then = function(){
		clearInterval(_this.loopInterval);
	}
	
	return _this;
	
	
	
	
	
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	// // // // // // // // // // // // // // // // // // // // // // // // // // // // // // 
	function changeVelocity( vel ){
		// ascend / descend
		if( _this.key_higher  &&  Key.isDown( _this.key_higher ) ){
			if( vel < _this._maxSpeed ){
				if(vel < 0)		decellerate();
				vel += _this._acel;
				// limit the max speed
				if( vel > _this._maxSpeed )		vel = _this._maxSpeed;
			}// if:   not at or beyond the max speed
		}else if( _this.key_lower  &&  Key.isDown( _this.key_lower ) ){
			if( vel > -_this._maxSpeed ){
				if(vel > 0)		decellerateTurn();
				vel -= _this._acel;
				// limit the max speed
				if( vel < -_this._maxSpeed )		vel = -_this._maxSpeed;
			}// if:   not at or beyond the max speed
		}else{
			decellerate();
		}
		function decellerate(){
			vel *= _this._decel;
			if( Math.abs( vel ) < 0.01 )		vel = 0;		// if less than 1 degree of rotation,  then => no rotation
		}// decellerate()
		
		return vel;
	}// changeVelocity()
	
}// makeRiseLower()